import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export class AccordionService {
    constructor() {
        this.items = [];
        this.alwaysOpen = false;
    }
    addItem(item) {
        this.items.push(item);
    }
    removeItem(item) {
        const index = this.items.indexOf(item);
        if (index !== -1) {
            this.items.splice(index, 1);
        }
    }
    toggleItem(item) {
        item.visible = !item.visible;
        this.closeOtherItems(item);
    }
    closeOtherItems(openItem) {
        if (!this.alwaysOpen) {
            this.items.forEach((item) => {
                if (item !== openItem) {
                    item.visible = false;
                }
            });
        }
    }
}
AccordionService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
AccordionService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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