import { Component, ContentChildren, HostBinding, } from '@angular/core';
import { slideAnimation, fadeAnimation } from '../carousel.animation';
import { CarouselItemComponent } from '../carousel-item/carousel-item.component';
import * as i0 from "@angular/core";
import * as i1 from "../carousel-state";
export class CarouselInnerComponent {
    constructor(carouselState) {
        this.carouselState = carouselState;
        this.carouselInnerClass = true;
        this.slide = { left: true };
        this.transition = 'slide';
    }
    ngAfterContentInit() {
        this.setItems();
    }
    ngAfterContentChecked() {
        this.setItems();
        const state = this.carouselState?.state;
        const nextIndex = state?.activeItemIndex;
        const nextDirection = state?.direction;
        if (this.activeIndex !== nextIndex) {
            this.animate = state?.animate;
            this.slide = { left: nextDirection === 'next' };
            this.activeIndex = state?.activeItemIndex;
            this.transition = state?.transition ?? 'slide';
        }
    }
    setItems() {
        if (this.prevContentItems !== this.contentItems) {
            this.prevContentItems = this.contentItems;
            this.carouselState.setItems(this.contentItems);
        }
    }
}
CarouselInnerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselInnerComponent, deps: [{ token: i1.CarouselState }], target: i0.ɵɵFactoryTarget.Component });
CarouselInnerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: CarouselInnerComponent, selector: "c-carousel-inner", host: { properties: { "class.carousel-inner": "this.carouselInnerClass" } }, queries: [{ propertyName: "contentItems", predicate: CarouselItemComponent }], ngImport: i0, template: "<div [@slideAnimation]=\"slide\" [@.disabled]=\"!animate\">\n  <ng-content></ng-content>\n</div>\n<!--todo-->\n<!--<div [@fadeAnimation]=\"slide\" [@.disabled]=\"!animate\" >-->\n<!--  <ng-content></ng-content>-->\n<!--</div>-->\n", styles: [":host{display:block}\n"], animations: [slideAnimation, fadeAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselInnerComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-carousel-inner', animations: [slideAnimation, fadeAnimation], template: "<div [@slideAnimation]=\"slide\" [@.disabled]=\"!animate\">\n  <ng-content></ng-content>\n</div>\n<!--todo-->\n<!--<div [@fadeAnimation]=\"slide\" [@.disabled]=\"!animate\" >-->\n<!--  <ng-content></ng-content>-->\n<!--</div>-->\n", styles: [":host{display:block}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.CarouselState }]; }, propDecorators: { carouselInnerClass: [{
                type: HostBinding,
                args: ['class.carousel-inner']
            }], contentItems: [{
                type: ContentChildren,
                args: [CarouselItemComponent]
            }] } });
//# sourceMappingURL=data:application/json;base64,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