import { Directive, HostBinding, HostListener, Input, Optional } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../dropdown.service";
import * as i2 from "../dropdown/dropdown.component";
export class DropdownItemDirective {
    constructor(dropdownService, dropdown) {
        this.dropdownService = dropdownService;
        this.dropdown = dropdown;
        /**
         * Configure dropdown-item close dropdown behavior.
         * @type boolean
         * @default true
         */
        this.autoClose = true;
        this._tabIndex = null;
    }
    get ariaCurrent() {
        return this.active ? 'true' : null;
    }
    get hostClasses() {
        return {
            'dropdown-item': true,
            active: this.active,
            disabled: this.disabled
        };
    }
    set tabIndex(value) {
        this._tabIndex = value;
    }
    get tabIndex() {
        return this.disabled ? '-1' : this._tabIndex;
    }
    get isDisabled() {
        return this.disabled || null;
    }
    onClick($event) {
        if (this.autoClose) {
            this.dropdownService.toggle({ visible: 'toggle', dropdown: this.dropdown });
        }
    }
    onKeyUp($event) {
        if ($event.key === 'Enter') {
            if (this.autoClose) {
                this.dropdownService.toggle({ visible: false, dropdown: this.dropdown });
            }
        }
    }
}
DropdownItemDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: DropdownItemDirective, deps: [{ token: i1.DropdownService }, { token: i2.DropdownComponent, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
DropdownItemDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: DropdownItemDirective, selector: "[cDropdownItem]", inputs: { active: "active", autoClose: "autoClose", disabled: "disabled", tabIndex: "tabIndex" }, host: { listeners: { "click": "onClick($event)", "keyup": "onKeyUp($event)" }, properties: { "attr.aria-current": "this.ariaCurrent", "class": "this.hostClasses", "attr.tabindex": "this.tabIndex", "attr.aria-disabled": "this.isDisabled" } }, exportAs: ["cDropdownItem"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: DropdownItemDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cDropdownItem]',
                    exportAs: 'cDropdownItem'
                }]
        }], ctorParameters: function () { return [{ type: i1.DropdownService }, { type: i2.DropdownComponent, decorators: [{
                    type: Optional
                }] }]; }, propDecorators: { active: [{
                type: Input
            }], autoClose: [{
                type: Input
            }], disabled: [{
                type: Input
            }], ariaCurrent: [{
                type: HostBinding,
                args: ['attr.aria-current']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], tabIndex: [{
                type: HostBinding,
                args: ['attr.tabindex']
            }, {
                type: Input
            }], isDisabled: [{
                type: HostBinding,
                args: ['attr.aria-disabled']
            }], onClick: [{
                type: HostListener,
                args: ['click', ['$event']]
            }], onKeyUp: [{
                type: HostListener,
                args: ['keyup', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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