import { IsActiveMatchOptions } from '@angular/router';
export declare enum BreakpointInfix {
    xs = "xs",
    sm = "sm",
    md = "md",
    lg = "lg",
    xl = "xl",
    xxl = "xxl"
}
export declare type BreakpointInfixStrings = keyof typeof BreakpointInfix;
export declare type Breakpoints = BreakpointInfixStrings | string;
export declare type Sizes = 'sm' | 'md' | 'lg' | 'xl' | 'xxl' | string;
export declare type Colors = 'primary' | 'secondary' | 'success' | 'danger' | 'warning' | 'info' | 'dark' | 'light' | string;
export declare type ColorsGradient = `${Colors}-gradient`;
export declare type BackgroundColors = Colors | 'body' | 'white' | 'transparent';
export declare type Directions = 'down' | 'up' | 'start' | 'end' | '';
export declare type TextColors = Colors | 'body' | 'white' | 'muted' | 'black-50' | 'white-50' | 'high-emphasis' | 'medium-emphasis' | 'disabled' | 'high-emphasis-inverse' | 'medium-emphasis-inverse' | 'disabled-inverse';
export declare type Alignment = 'baseline' | 'top' | 'middle' | 'bottom' | 'text-top' | 'text-bottom';
export declare type BadgePositions = 'top-start' | 'top-end' | 'bottom-end' | 'bottom-start' | string | undefined;
export declare type Placements = 'auto' | 'auto-start' | 'auto-end' | 'top-end' | 'top' | 'top-start' | 'bottom-end' | 'bottom' | 'bottom-start' | 'right-start' | 'right' | 'right-end' | 'left-start' | 'left' | 'left-end' | undefined;
export declare type Shapes = 'rounded' | 'rounded-top' | 'rounded-end' | 'rounded-bottom' | 'rounded-start' | 'rounded-circle' | 'rounded-pill' | 'rounded-0' | 'rounded-1' | 'rounded-2' | 'rounded-3' | string;
export declare type Triggers = 'hover' | 'focus' | 'click';
export declare type Positions = 'fixed' | 'sticky';
export declare type InputType = 'button' | 'color' | 'date' | 'datetime' | 'datetime-local' | 'email' | 'file' | 'hidden' | 'image' | 'month' | 'number' | 'password' | 'range' | 'reset' | 'search' | 'submit' | 'tel' | 'text' | 'time' | 'url' | 'week' | 'checkbox' | 'radio';
export interface INavLinkProps {
    queryParams?: {
        [k: string]: any;
    };
    fragment?: string;
    queryParamsHandling?: 'merge' | 'preserve' | '' | null;
    preserveFragment?: boolean;
    skipLocationChange?: boolean;
    replaceUrl?: boolean;
    state?: {
        [k: string]: any;
    };
    routerLinkActiveOptions?: {
        exact: boolean;
    } | IsActiveMatchOptions;
    routerLinkActive?: string | string[];
    ariaCurrentWhenActive?: 'page' | 'step' | 'location' | 'date' | 'time' | true | false;
}
export interface INavAttributes {
    [propName: string]: any;
}
export declare type ButtonType = 'button' | 'submit' | 'reset';
