/**
 * Utility used to transform the `auto` placement to the placement with more
 * available space.
 */
import { getBoundaries } from './getBoundaries';
import { PlacementForBs5 } from '../models';
import { getBsVer } from 'ngx-bootstrap/utils';
function getArea({ width, height }) {
    return width * height;
}
export function computeAutoPlacement(placement, refRect, target, host, allowedPositions = ['top', 'bottom', 'right', 'left'], boundariesElement = 'viewport', padding = 0) {
    if (placement.indexOf('auto') === -1) {
        return placement;
    }
    const boundaries = getBoundaries(target, host, padding, boundariesElement);
    const rects = {
        top: {
            width: boundaries?.width ?? 0,
            height: (refRect?.top ?? 0) - (boundaries?.top ?? 0)
        },
        right: {
            width: (boundaries?.right ?? 0) - (refRect?.right ?? 0),
            height: boundaries?.height ?? 0
        },
        bottom: {
            width: boundaries?.width ?? 0,
            height: (boundaries?.bottom ?? 0) - (refRect?.bottom ?? 0)
        },
        left: {
            width: (refRect.left ?? 0) - (boundaries?.left ?? 0),
            height: boundaries?.height ?? 0
        }
    };
    const sortedAreas = Object.keys(rects)
        .map((key) => ({
        position: key,
        ...rects[key],
        area: getArea(rects[key])
    }))
        .sort((a, b) => b.area - a.area);
    let filteredAreas = sortedAreas.filter(({ width, height }) => {
        return width >= target.clientWidth && height >= target.clientHeight;
    });
    filteredAreas = filteredAreas.filter(({ position }) => {
        return allowedPositions.some((allowedPosition) => {
            return allowedPosition === position;
        });
    });
    const computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].position : sortedAreas[0].position;
    const variation = placement.split(' ')[1];
    // for tooltip on auto position
    target.className = target.className.replace(/bs-tooltip-auto/g, `bs-tooltip-${getBsVer().isBs5 ? PlacementForBs5[computedPlacement] : computedPlacement}`);
    return computedPlacement + (variation ? `-${variation}` : '');
}
//# sourceMappingURL=data:application/json;base64,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