/**
 * Get offsets to the target
 */
import { getOppositePlacement } from './getOppositePlacement';
import { getOuterSizes } from './getOuterSizes';
export function getTargetOffsets(target, hostOffsets, position) {
    const placement = position.split(' ')[0];
    // Get target node sizes
    const targetRect = getOuterSizes(target);
    // Add position, width and height to our offsets object
    const targetOffsets = {
        width: targetRect.width,
        height: targetRect.height
    };
    // depending by the target placement we have to compute its offsets slightly differently
    const isHoriz = ['right', 'left'].indexOf(placement) !== -1;
    const mainSide = isHoriz ? 'top' : 'left';
    const secondarySide = isHoriz ? 'left' : 'top';
    const measurement = isHoriz ? 'height' : 'width';
    const secondaryMeasurement = !isHoriz ? 'height' : 'width';
    targetOffsets[mainSide] =
        (hostOffsets[mainSide] ?? 0) +
            hostOffsets[measurement] / 2 -
            targetRect[measurement] / 2;
    targetOffsets[secondarySide] = placement === secondarySide
        ? (hostOffsets[secondarySide] ?? 0) - targetRect[secondaryMeasurement]
        : hostOffsets[getOppositePlacement(secondarySide)] ?? 0;
    return targetOffsets;
}
//# sourceMappingURL=data:application/json;base64,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