/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Directive, HostListener, Input } from '@angular/core';
export class NgxPrintDirective {
    constructor() {
        this._printStyle = [];
        /**
         *
         *
         * \@memberof NgxPrintDirective
         */
        this.useExistingCss = false;
        /**
         * A delay in milliseconds to force the print dialog to wait before opened. Default: 0
         *
         * \@memberof NgxPrintDirective
         */
        this.printDelay = 0;
        /**
         *
         *
         * @return html for the given tag
         *
         * \@memberof NgxPrintDirective
         */
        this._styleSheetFile = '';
    }
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @param {?} values
     * @return {?}
     */
    set printStyle(values) {
        for (let key in values) {
            if (values.hasOwnProperty(key)) {
                this._printStyle.push((key + JSON.stringify(values[key])).replace(/['"]+/g, ''));
            }
        }
        this.returnStyleValues();
    }
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @return {?} the string that create the stylesheet which will be injected
     * later within <style></style> tag.
     *
     * -join/replace to transform an array objects to css-styled string
     *
     */
    returnStyleValues() {
        return `<style> ${this._printStyle.join(' ').replace(/,/g, ';')} </style>`;
    }
    /**
     * \@memberof NgxPrintDirective
     * @param {?} cssList
     * @return {?}
     */
    set styleSheetFile(cssList) {
        /** @type {?} */
        let linkTagFn = (/**
         * @param {?} cssFileName
         * @return {?}
         */
        function (cssFileName) {
            return `<link rel="stylesheet" type="text/css" href="${cssFileName}">`;
        });
        if (cssList.indexOf(',') !== -1) {
            /** @type {?} */
            const valueArr = cssList.split(',');
            for (let val of valueArr) {
                this._styleSheetFile = this._styleSheetFile + linkTagFn(val);
            }
        }
        else {
            this._styleSheetFile = linkTagFn(cssList);
        }
    }
    /**
     * @private
     * @return {?} string which contains the link tags containing the css which will
     * be injected later within <head></head> tag.
     *
     */
    returnStyleSheetLinkTags() {
        return this._styleSheetFile;
    }
    /**
     * @private
     * @param {?} tag
     * @return {?}
     */
    getElementTag(tag) {
        /** @type {?} */
        const html = [];
        /** @type {?} */
        const elements = document.getElementsByTagName(tag);
        for (let index = 0; index < elements.length; index++) {
            html.push(elements[index].outerHTML);
        }
        return html.join('\r\n');
    }
    /**
     *
     * @private
     * @param {?} data the html element collection to save defaults to
     *
     * @return {?}
     */
    getFormData(data) {
        for (var i = 0; i < data.length; i++) {
            data[i].defaultValue = data[i].value;
            if (data[i].checked) {
                data[i].defaultChecked = true;
            }
        }
    }
    /**
     * @private
     * @return {?} html section to be printed along with some associated inputs
     *
     */
    getHtmlContents() {
        /** @type {?} */
        let printContents = document.getElementById(this.printSectionId);
        /** @type {?} */
        let innards = printContents.getElementsByTagName('input');
        this.getFormData(innards);
        /** @type {?} */
        let txt = printContents.getElementsByTagName('textarea');
        this.getFormData(txt);
        return printContents.innerHTML;
    }
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @return {?}
     */
    print() {
        /** @type {?} */
        let printContents;
        /** @type {?} */
        let popupWin;
        /** @type {?} */
        let styles = '';
        /** @type {?} */
        let links = '';
        /** @type {?} */
        const baseTag = this.getElementTag('base');
        if (this.useExistingCss) {
            styles = this.getElementTag('style');
            links = this.getElementTag('link');
        }
        printContents = this.getHtmlContents();
        popupWin = window.open("", "_blank", "top=0,left=0,height=auto,width=auto");
        popupWin.document.open();
        popupWin.document.write(`
      <html>
        <head>
          <title>${this.printTitle ? this.printTitle : ""}</title>
          ${baseTag}
          ${this.returnStyleValues()}
          ${this.returnStyleSheetLinkTags()}
          ${styles}
          ${links}
        </head>
        <body>
          ${printContents}
          <script defer>
            function triggerPrint(event) {
              window.removeEventListener('load', triggerPrint, false);
              setTimeout(function() {
                closeWindow(window.print());
              }, ${this.printDelay});
            }
            function closeWindow(){
                window.close();
            }
            window.addEventListener('load', triggerPrint, false);
          </script>
        </body>
      </html>`);
        popupWin.document.close();
    }
}
NgxPrintDirective.decorators = [
    { type: Directive, args: [{
                selector: "button[ngxPrint]"
            },] }
];
NgxPrintDirective.propDecorators = {
    printSectionId: [{ type: Input }],
    printTitle: [{ type: Input }],
    useExistingCss: [{ type: Input }],
    printDelay: [{ type: Input }],
    printStyle: [{ type: Input }],
    styleSheetFile: [{ type: Input }],
    print: [{ type: HostListener, args: ['click',] }]
};
if (false) {
    /** @type {?} */
    NgxPrintDirective.prototype._printStyle;
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     */
    NgxPrintDirective.prototype.printSectionId;
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     */
    NgxPrintDirective.prototype.printTitle;
    /**
     *
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     */
    NgxPrintDirective.prototype.useExistingCss;
    /**
     * A delay in milliseconds to force the print dialog to wait before opened. Default: 0
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     */
    NgxPrintDirective.prototype.printDelay;
    /**
     *
     *
     * \@return html for the given tag
     *
     * \@memberof NgxPrintDirective
     * @type {?}
     * @private
     */
    NgxPrintDirective.prototype._styleSheetFile;
}
//# sourceMappingURL=data:application/json;base64,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