/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export class DataSource {
}
/** Checks whether an object is a data source. */
export function isDataSource(value) {
    // Check if the value is a DataSource by observing if it has a connect function. Cannot
    // be checked as an `instanceof DataSource` since people could create their own sources
    // that match the interface, but don't extend DataSource.
    return value && typeof value.connect === 'function';
}
//# sourceMappingURL=data:application/json;base64,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