/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/** Whether test modules should be torn down by default. */
export const TEARDOWN_TESTING_MODULE_ON_DESTROY_DEFAULT = true;
/** Whether unknown elements in templates should throw by default. */
export const THROW_ON_UNKNOWN_ELEMENTS_DEFAULT = false;
/** Whether unknown properties in templates should throw by default. */
export const THROW_ON_UNKNOWN_PROPERTIES_DEFAULT = false;
/**
 * An abstract class for inserting the root test component element in a platform independent way.
 *
 * @publicApi
 */
export class TestComponentRenderer {
    insertRootElement(rootElementId) { }
    removeAllRootElements() { }
}
/**
 * @publicApi
 */
export const ComponentFixtureAutoDetect = new InjectionToken('ComponentFixtureAutoDetect');
/**
 * @publicApi
 */
export const ComponentFixtureNoNgZone = new InjectionToken('ComponentFixtureNoNgZone');
//# sourceMappingURL=data:application/json;base64,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