/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { bootstrapApplication, BrowserModule, platformBrowser, provideProtractorTestingSupport } from './browser';
export { Meta } from './browser/meta';
export { Title } from './browser/title';
export { disableDebugTools, enableDebugTools } from './browser/tools/tools';
export { BrowserTransferStateModule, makeStateKey, TransferState } from './browser/transfer_state';
export { By } from './dom/debug/by';
export { EVENT_MANAGER_PLUGINS, EventManager } from './dom/events/event_manager';
export { HAMMER_GESTURE_CONFIG, HAMMER_LOADER, HammerGestureConfig, HammerModule } from './dom/events/hammer_gestures';
export { DomSanitizer } from './security/dom_sanitization_service';
export * from './private_export';
export { VERSION } from './version';
//# sourceMappingURL=data:application/json;base64,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