import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty, coerceNumberProperty } from '@angular/cdk/coercion';
import { BreakpointInfix } from '../coreui.types';
import * as i0 from "@angular/core";
export class ColDirective {
    constructor() {
        this._xs = false;
        this._sm = false;
        this._md = false;
        this._lg = false;
        this._xl = false;
        this._xxl = false;
    }
    /**
     * The number of columns/offset/order on extra small devices (<576px).
     * @type { 'auto' | number |  boolean }
     */
    set cCol(value) {
        this.xs = this.xs || this.coerceInput(value);
    }
    set xs(value) {
        this._xs = this.coerceInput(value);
    }
    get xs() {
        return this._xs;
    }
    /**
     * The number of columns/offset/order on small devices (<768px).
     * @type { 'auto' | number |  boolean }
     */
    set sm(value) {
        this._sm = this.coerceInput(value);
    }
    get sm() {
        return this._sm;
    }
    /**
     * The number of columns/offset/order on medium devices (<992px).
     * @type { 'auto' | number |  boolean }
     */
    set md(value) {
        this._md = this.coerceInput(value);
    }
    get md() {
        return this._md;
    }
    /**
     * The number of columns/offset/order on large devices (<1200px).
     * @type { 'auto' | number |  boolean }
     */
    set lg(value) {
        this._lg = this.coerceInput(value);
    }
    get lg() {
        return this._lg;
    }
    /**
     * The number of columns/offset/order on X-Large devices (<1400px).
     * @type { 'auto' | number |  boolean }
     */
    set xl(value) {
        this._xl = this.coerceInput(value);
    }
    get xl() {
        return this._xl;
    }
    /**
     * The number of columns/offset/order on XX-Large devices (≥1400px).
     * @type { 'auto' | number |  boolean }
     */
    set xxl(value) {
        this._xxl = this.coerceInput(value);
    }
    get xxl() {
        return this._xxl;
    }
    get hostClasses() {
        const classes = {
            col: true
        };
        Object.keys(BreakpointInfix).forEach((breakpoint) => {
            // @ts-ignore
            const value = this[breakpoint];
            const infix = breakpoint === 'xs' ? '' : `-${breakpoint}`;
            classes[`col${infix}`] = value === true;
            classes[`col${infix}-${value}`] = (typeof value === 'number') || (typeof value === 'string');
        });
        if (typeof this.offset === 'object') {
            const offset = { ...this.offset };
            Object.entries(offset).forEach((entry) => {
                const [breakpoint, value] = [...entry];
                const infix = breakpoint === 'xs' ? '' : `-${breakpoint}`;
                classes[`offset${infix}-${value}`] = value >= 0 && value <= 11;
            });
        }
        else {
            classes[`offset-${this.offset}`] = (typeof this.offset === 'number') && this.offset > 0 && this.offset <= 11;
        }
        if (typeof this.order === 'object') {
            const order = { ...this.order };
            Object.entries(order).forEach((entry) => {
                const [breakpoint, value] = [...entry];
                const infix = breakpoint === 'xs' ? '' : `-${breakpoint}`;
                classes[`order${infix}-${value}`] = value;
            });
        }
        else {
            classes[`order-${this.order}`] = !!this.order;
        }
        // if there is no 'col' class, add one
        classes.col = (!Object.entries(classes).filter(i => i[0].startsWith('col-') && i[1]).length) || this.xs === true;
        return classes;
    }
    coerceInput(value) {
        if (value === 'auto') {
            return value;
        }
        if (value === '' || value === undefined || value === null) {
            return coerceBooleanProperty(value);
        }
        if (typeof value === 'boolean') {
            return value;
        }
        return coerceNumberProperty(value);
    }
}
ColDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ColDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
ColDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: ColDirective, selector: "[cCol]", inputs: { cCol: "cCol", xs: "xs", sm: "sm", md: "md", lg: "lg", xl: "xl", xxl: "xxl", offset: "offset", order: "order" }, host: { properties: { "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ColDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cCol]'
                }]
        }], propDecorators: { cCol: [{
                type: Input
            }], xs: [{
                type: Input
            }], sm: [{
                type: Input
            }], md: [{
                type: Input
            }], lg: [{
                type: Input
            }], xl: [{
                type: Input
            }], xxl: [{
                type: Input
            }], offset: [{
                type: Input
            }], order: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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