import { Directive, HostBinding, Input } from '@angular/core';
import * as i0 from "@angular/core";
export class BgColorDirective {
    constructor() {
        /**
         * Set the background of an element to any contextual class
         */
        this.color = '';
    }
    get hostClasses() {
        return {
            [`bg-${this.color}`]: !!this.color,
            'bg-gradient': this.gradient,
        };
    }
}
BgColorDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: BgColorDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
BgColorDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: BgColorDirective, selector: "[cBgColor]", inputs: { color: ["cBgColor", "color"], gradient: "gradient" }, host: { properties: { "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: BgColorDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cBgColor]'
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { color: [{
                type: Input,
                args: ['cBgColor']
            }], gradient: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmctY29sb3IuZGlyZWN0aXZlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvY29yZXVpLWFuZ3VsYXIvc3JjL2xpYi91dGlsaXRpZXMvYmctY29sb3IuZGlyZWN0aXZlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsV0FBVyxFQUFFLEtBQUssRUFBRSxNQUFNLGVBQWUsQ0FBQzs7QUFNOUQsTUFBTSxPQUFPLGdCQUFnQjtJQW9CM0I7UUFsQkE7O1dBRUc7UUFDZ0IsVUFBSyxHQUFxQixFQUFFLENBQUM7SUFlaEMsQ0FBQztJQVJqQixJQUNJLFdBQVc7UUFDYixPQUFPO1lBQ0wsQ0FBQyxNQUFNLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSztZQUNsQyxhQUFhLEVBQUUsSUFBSSxDQUFDLFFBQVE7U0FDN0IsQ0FBQztJQUNKLENBQUM7OzZHQWxCVSxnQkFBZ0I7aUdBQWhCLGdCQUFnQjsyRkFBaEIsZ0JBQWdCO2tCQUg1QixTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSxZQUFZO2lCQUN2QjswRUFNb0IsS0FBSztzQkFBdkIsS0FBSzt1QkFBQyxVQUFVO2dCQUtSLFFBQVE7c0JBQWhCLEtBQUs7Z0JBR0YsV0FBVztzQkFEZCxXQUFXO3VCQUFDLE9BQU8iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEaXJlY3RpdmUsIEhvc3RCaW5kaW5nLCBJbnB1dCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQmFja2dyb3VuZENvbG9ycyB9IGZyb20gJy4uL2NvcmV1aS50eXBlcyc7XG5cbkBEaXJlY3RpdmUoe1xuICBzZWxlY3RvcjogJ1tjQmdDb2xvcl0nXG59KVxuZXhwb3J0IGNsYXNzIEJnQ29sb3JEaXJlY3RpdmUge1xuXG4gIC8qKlxuICAgKiBTZXQgdGhlIGJhY2tncm91bmQgb2YgYW4gZWxlbWVudCB0byBhbnkgY29udGV4dHVhbCBjbGFzc1xuICAgKi9cbiAgQElucHV0KCdjQmdDb2xvcicpIGNvbG9yOiBCYWNrZ3JvdW5kQ29sb3JzID0gJyc7XG4gIC8qKlxuICAgKiBBZGQgbGluZWFyIGdyYWRpZW50IGFzIGJhY2tncm91bmQgaW1hZ2UgdG8gdGhlIGJhY2tncm91bmRzLlxuICAgKiBAdHlwZSBib29sZWFuXG4gICAqL1xuICBASW5wdXQoKSBncmFkaWVudD86IGJvb2xlYW47XG5cbiAgQEhvc3RCaW5kaW5nKCdjbGFzcycpXG4gIGdldCBob3N0Q2xhc3NlcygpOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICBbYGJnLSR7dGhpcy5jb2xvcn1gXTogISF0aGlzLmNvbG9yLFxuICAgICAgJ2JnLWdyYWRpZW50JzogdGhpcy5ncmFkaWVudCxcbiAgICB9O1xuICB9XG5cbiAgY29uc3RydWN0b3IoKSB7IH1cbn1cbiJdfQ==