import { Component, ContentChildren, HostBinding, Input } from '@angular/core';
import { TemplateIdDirective } from '../../shared';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "../../card/card-body.component";
export class WidgetStatAComponent {
    constructor() {
        this.templates = {};
    }
    get hostClasses() {
        return {
            'card': true,
            [`bg-${this.color}`]: !!this.color,
            'text-high-emphasis-inverse': !!this.color
        };
    }
    get bodyClasses() {
        return {
            'pb-0': true,
            'd-flex': true,
            'justify-content-between': true,
            'align-items-start': true,
        };
    }
    ngAfterContentInit() {
        this.contentTemplates.forEach((child) => {
            this.templates[child.id] = child.templateRef;
        });
    }
}
WidgetStatAComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: WidgetStatAComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
WidgetStatAComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: WidgetStatAComponent, selector: "c-widget-stat-a", inputs: { color: "color", title: "title", value: "value" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "contentTemplates", predicate: TemplateIdDirective, descendants: true }], exportAs: ["cWidgetStatA"], ngImport: i0, template: "<ng-container>\n  <c-card-body [ngClass]=\"bodyClasses\">\n    <div>\n      <div *ngIf=\"!!value || templates?.widgetValueTemplate\" class=\"fs-4 fw-semibold\">\n        <ng-container *ngTemplateOutlet=\"templates?.widgetValueTemplate || defaultWidgetValueTemplate\"></ng-container>\n      </div>\n      <div *ngIf=\"!!title || templates?.widgetTitleTemplate\">\n        <ng-container *ngTemplateOutlet=\"templates?.widgetTitleTemplate || defaultWidgetTitleTemplate\"></ng-container>\n      </div>\n    </div>\n    <ng-container *ngTemplateOutlet=\"templates?.widgetActionTemplate || defaultWidgetActionTemplate\"></ng-container>\n  </c-card-body>\n  <ng-container *ngTemplateOutlet=\"templates?.widgetChartTemplate || defaultWidgetChartTemplate\"></ng-container>\n</ng-container>\n\n<ng-template #defaultWidgetTitleTemplate>\n  {{title}}\n</ng-template>\n\n<ng-template #defaultWidgetValueTemplate>\n  {{value}}\n</ng-template>\n\n<ng-template #defaultWidgetChartTemplate>\n  <ng-content select=\".chart-wrapper\"></ng-content>\n</ng-template>\n\n<ng-template #defaultWidgetActionTemplate>\n  <ng-content></ng-content>\n</ng-template>\n", styles: [""], dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i1.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "component", type: i2.CardBodyComponent, selector: "c-card-body, [c-card-body]" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: WidgetStatAComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-widget-stat-a', exportAs: 'cWidgetStatA', template: "<ng-container>\n  <c-card-body [ngClass]=\"bodyClasses\">\n    <div>\n      <div *ngIf=\"!!value || templates?.widgetValueTemplate\" class=\"fs-4 fw-semibold\">\n        <ng-container *ngTemplateOutlet=\"templates?.widgetValueTemplate || defaultWidgetValueTemplate\"></ng-container>\n      </div>\n      <div *ngIf=\"!!title || templates?.widgetTitleTemplate\">\n        <ng-container *ngTemplateOutlet=\"templates?.widgetTitleTemplate || defaultWidgetTitleTemplate\"></ng-container>\n      </div>\n    </div>\n    <ng-container *ngTemplateOutlet=\"templates?.widgetActionTemplate || defaultWidgetActionTemplate\"></ng-container>\n  </c-card-body>\n  <ng-container *ngTemplateOutlet=\"templates?.widgetChartTemplate || defaultWidgetChartTemplate\"></ng-container>\n</ng-container>\n\n<ng-template #defaultWidgetTitleTemplate>\n  {{title}}\n</ng-template>\n\n<ng-template #defaultWidgetValueTemplate>\n  {{value}}\n</ng-template>\n\n<ng-template #defaultWidgetChartTemplate>\n  <ng-content select=\".chart-wrapper\"></ng-content>\n</ng-template>\n\n<ng-template #defaultWidgetActionTemplate>\n  <ng-content></ng-content>\n</ng-template>\n" }]
        }], propDecorators: { color: [{
                type: Input
            }], title: [{
                type: Input
            }], value: [{
                type: Input
            }], contentTemplates: [{
                type: ContentChildren,
                args: [TemplateIdDirective, { descendants: true }]
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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