import { ChangeDetectorRef, ElementRef, EventEmitter, OnDestroy, OnInit, Renderer2 } from '@angular/core';
import { AnimationEvent } from '@angular/animations';
import { BooleanInput } from '@angular/cdk/coercion';
import { ToasterService } from '../toaster/toaster.service';
import { TToasterPlacement } from '../toaster/toaster.component';
import { Colors } from '../../coreui.types';
import * as i0 from "@angular/core";
declare type AnimateType = ('hide' | 'show');
export declare class ToastComponent implements OnInit, OnDestroy {
    hostElement: ElementRef;
    renderer: Renderer2;
    toasterService: ToasterService;
    changeDetectorRef: ChangeDetectorRef;
    static ngAcceptInputType_visible: BooleanInput;
    dynamic: boolean;
    placement: TToasterPlacement;
    hide: boolean;
    /**
     * Auto hide the toast.
     * @type boolean
     */
    autohide: boolean;
    /**
     * Sets the color context of the component to one of CoreUI’s themed colors.
     * @type Colors
     */
    color?: Colors;
    /**
     * Delay hiding the toast (ms).
     * @type number
     */
    delay: number;
    /**
     * Apply fade transition to the toast.
     * @type boolean
     */
    fade: boolean;
    /**
     * Toggle the visibility of component.
     * @type boolean
     */
    set visible(value: boolean);
    get visible(): boolean;
    private _visible;
    /**
     * @ignore
     */
    index?: number;
    /**
     * Event emitted on visibility change. [docs]
     * @type boolean
     */
    visibleChange: EventEmitter<boolean>;
    /**
     * Event emitted on timer tick. [docs]
     * @type number
     */
    timer: EventEmitter<number>;
    private timerId;
    private clockId;
    private clockTimerId;
    constructor(hostElement: ElementRef, renderer: Renderer2, toasterService: ToasterService, changeDetectorRef: ChangeDetectorRef);
    private _clock;
    get clock(): number;
    set clock(value: number);
    get animationDisabled(): boolean;
    get animateType(): AnimateType;
    onAnimationStart($event: AnimationEvent): void;
    onAnimationDone($event: AnimationEvent): void;
    onMouseOver(): void;
    onMouseOut(): void;
    get hostClasses(): any;
    ngOnInit(): void;
    ngOnDestroy(): void;
    setTimer(): void;
    clearTimer(): void;
    onClose(): void;
    setClock(): void;
    clearClock(): void;
    onAnimationEvent(event: AnimationEvent): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ToastComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<ToastComponent, "c-toast", ["cToast"], { "autohide": "autohide"; "color": "color"; "delay": "delay"; "fade": "fade"; "visible": "visible"; "index": "index"; }, { "visibleChange": "visibleChange"; "timer": "timer"; }, never, ["*"], false>;
}
export {};
