import { Directive, HostBinding, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/platform-browser";
import * as i2 from "../icon-set";
export class IconDirective {
    constructor(renderer, elementRef, sanitizer, iconSet) {
        this.renderer = renderer;
        this.elementRef = elementRef;
        this.sanitizer = sanitizer;
        this.iconSet = iconSet;
        this.size = '';
        this.xmlns = 'http://www.w3.org/2000/svg';
        this.pointerEvents = 'none';
        this.role = 'img';
    }
    set name(name) {
        this._name = name?.includes('-') ? this.toCamelCase(name) : name;
    }
    get name() {
        return this._name;
    }
    set viewBox(viewBox) {
        this._viewBox = viewBox;
    }
    get viewBox() {
        return this._viewBox ?? this.scale;
    }
    get hostClasses() {
        const classes = {
            icon: true,
            [`icon-${this.computedSize}`]: !!this.computedSize
        };
        return this.customClasses ?? classes;
    }
    get innerHtml() {
        const code = Array.isArray(this.code) ? this.code[1] || this.code[0] : this.code ?? '';
        // todo proper sanitize
        // const sanitized = this.sanitizer.sanitize(SecurityContext.HTML, code);
        return this.sanitizer.bypassSecurityTrustHtml((this.titleCode + code) ?? '');
    }
    get titleCode() {
        return this.title ? `<title>${this.title}</title>` : '';
    }
    get code() {
        if (this.content) {
            return this.content;
        }
        if (this.iconSet && this.name) {
            return this.iconSet.getIcon(this.name);
        }
        if (this.name && !this.iconSet?.icons[this.name])
            console.warn(`c-icon component: icon name '${this.name}' does not exist for IconSet service. ` +
                `To use icon by 'name' prop you need to add it to IconSet service. \n`, this.name);
        return undefined;
    }
    get scale() {
        return Array.isArray(this.code) && this.code.length > 1 ? `0 0 ${this.code[0]}` : '0 0 64 64';
    }
    get computedSize() {
        const addCustom = !this.size && (this.width || this.height);
        return this.size === 'custom' || addCustom ? 'custom-size' : this.size;
    }
    get computedClasses() {
        const classes = {
            icon: true,
            [`icon-${this.computedSize}`]: !!this.computedSize
        };
        return !!this.customClasses ? this.customClasses : classes;
    }
    toCamelCase(str) {
        return str.replace(/([-_][a-z0-9])/ig, ($1) => {
            return $1.toUpperCase().replace('-', '');
        });
    }
}
IconDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: IconDirective, deps: [{ token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i1.DomSanitizer }, { token: i2.IconSetService }], target: i0.ɵɵFactoryTarget.Directive });
IconDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: IconDirective, selector: "svg[cIcon]", inputs: { content: ["cIcon", "content"], size: "size", title: "title", customClasses: "customClasses", width: "width", height: "height", name: "name", viewBox: "viewBox", xmlns: "xmlns", pointerEvents: ["pointer-events", "pointerEvents"], role: "role" }, host: { properties: { "attr.viewBox": "this.viewBox", "attr.xmlns": "this.xmlns", "attr.pointer-events": "this.pointerEvents", "attr.role": "this.role", "class": "this.hostClasses", "innerHtml": "this.innerHtml" } }, exportAs: ["cIcon"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: IconDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: 'svg[cIcon]',
                    exportAs: 'cIcon'
                }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i1.DomSanitizer }, { type: i2.IconSetService }]; }, propDecorators: { content: [{
                type: Input,
                args: ['cIcon']
            }], size: [{
                type: Input
            }], title: [{
                type: Input
            }], customClasses: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }], name: [{
                type: Input
            }], viewBox: [{
                type: HostBinding,
                args: ['attr.viewBox']
            }, {
                type: Input
            }], xmlns: [{
                type: HostBinding,
                args: ['attr.xmlns']
            }, {
                type: Input
            }], pointerEvents: [{
                type: HostBinding,
                args: ['attr.pointer-events']
            }, {
                type: Input,
                args: ['pointer-events']
            }], role: [{
                type: HostBinding,
                args: ['attr.role']
            }, {
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], innerHtml: [{
                type: HostBinding,
                args: ['innerHtml']
            }] } });
//# sourceMappingURL=data:application/json;base64,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