import { baseColors } from './base-colors';
export const builtInDefaults = {
    datasets: {
        line: {
            backgroundColor: (context) => rgba(generateColor(context.datasetIndex), 0.4),
            borderColor: (context) => rgba(generateColor(context.datasetIndex), 1),
            pointBackgroundColor: (context) => rgba(generateColor(context.datasetIndex), 1),
            pointBorderColor: '#fff',
            pointHoverBackgroundColor: '#fff',
            pointHoverBorderColor: (context) => rgba(generateColor(context.datasetIndex), 0.8)
        },
        bar: {
            backgroundColor: (context) => rgba(generateColor(context.datasetIndex), 0.6),
            borderColor: (context) => rgba(generateColor(context.datasetIndex), 1),
            hoverBackgroundColor: (context) => rgba(generateColor(context.datasetIndex), 0.8),
            hoverBorderColor: (context) => rgba(generateColor(context.datasetIndex), 1)
        },
        get radar() {
            return this.line;
        },
        doughnut: {
            backgroundColor: (context) => rgba(generateColor(context.dataIndex), 0.6),
            borderColor: '#fff',
            hoverBackgroundColor: (context) => rgba(generateColor(context.dataIndex), 1),
            hoverBorderColor: (context) => rgba(generateColor(context.dataIndex), 1)
        },
        get pie() {
            return this.doughnut;
        },
        polarArea: {
            backgroundColor: (context) => rgba(generateColor(context.dataIndex), 0.6),
            borderColor: (context) => rgba(generateColor(context.dataIndex), 1),
            hoverBackgroundColor: (context) => rgba(generateColor(context.dataIndex), 0.8),
            hoverBorderColor: (context) => rgba(generateColor(context.dataIndex), 1)
        },
        get bubble() {
            return this.doughnut;
        },
        get scatter() {
            return this.doughnut;
        },
        get area() {
            return this.polarArea;
        }
    }
};
function rgba(colour, alpha) {
    return 'rgba(' + colour.concat(alpha).join(',') + ')';
}
function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}
function getRandomColor() {
    return [getRandomInt(0, 255), getRandomInt(0, 255), getRandomInt(0, 255)];
}
/**
 * Generate colors
 */
function generateColor(index = 0) {
    return baseColors[index] || getRandomColor();
}
//# sourceMappingURL=data:application/json;base64,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