import { endOf, startOf } from './start-end-of';
export function isAfter(date1, date2, units = 'milliseconds') {
    if (!date1 || !date2) {
        return false;
    }
    if (units === 'milliseconds') {
        return date1.valueOf() > date2.valueOf();
    }
    return date2.valueOf() < startOf(date1, units).valueOf();
}
export function isBefore(date1, date2, units = 'milliseconds') {
    if (!date1 || !date2) {
        return false;
    }
    if (units === 'milliseconds') {
        return date1.valueOf() < date2.valueOf();
    }
    return endOf(date1, units).valueOf() < date2.valueOf();
}
export function isDisabledDay(date, daysDisabled) {
    if (typeof daysDisabled === 'undefined' || !daysDisabled || !daysDisabled.length) {
        return false;
    }
    return daysDisabled.some((day) => day === date.getDay());
}
export function isBetween(date, from, to, units, inclusivity = '()') {
    const leftBound = inclusivity[0] === '('
        ? isAfter(date, from, units)
        : !isBefore(date, from, units);
    const rightBound = inclusivity[1] === ')'
        ? isBefore(date, to, units)
        : !isAfter(date, to, units);
    return leftBound && rightBound;
}
export function isSame(date1, date2, units = 'milliseconds') {
    if (!date1 || !date2) {
        return false;
    }
    if (units === 'milliseconds') {
        return date1.valueOf() === date2.valueOf();
    }
    const inputMs = date2.valueOf();
    return (startOf(date1, units).valueOf() <= inputMs &&
        inputMs <= endOf(date1, units).valueOf());
}
export function isSameDay(date1, date2) {
    return (date1.getDay() == date2.getDay());
}
export function isSameOrAfter(date1, date2, units) {
    return isSame(date1, date2, units) || isAfter(date1, date2, units);
}
export function isSameOrBefore(date1, date2, units) {
    return isSame(date1, date2, units) || isBefore(date1, date2, units);
}
//# sourceMappingURL=data:application/json;base64,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