import { AfterViewInit, ElementRef, EventEmitter, OnDestroy, OnInit, Renderer2 } from '@angular/core';
import { Subscription } from 'rxjs';
import { PositioningService } from 'ngx-bootstrap/positioning';
import { TimepickerComponent } from 'ngx-bootstrap/timepicker';
import { BsDatepickerAbstractComponent } from '../../base/bs-datepicker-container';
import { BsDatepickerConfig } from '../../bs-datepicker.config';
import { CalendarCellViewModel, DayViewModel } from '../../models';
import { BsDatepickerActions } from '../../reducer/bs-datepicker.actions';
import { BsDatepickerEffects } from '../../reducer/bs-datepicker.effects';
import { BsDatepickerStore } from '../../reducer/bs-datepicker.store';
import { BsCustomDates } from './bs-custom-dates-view.component';
import * as i0 from "@angular/core";
export declare class BsDaterangepickerContainerComponent extends BsDatepickerAbstractComponent implements OnInit, OnDestroy, AfterViewInit {
    private _config;
    private _store;
    private _element;
    private _actions;
    private _positionService;
    set value(value: (Date | undefined)[] | undefined);
    valueChange: EventEmitter<Date[]>;
    animationState: string;
    _rangeStack: Date[];
    chosenRange: Date[];
    _subs: Subscription[];
    isRangePicker: boolean;
    startTimepicker?: TimepickerComponent;
    endTimepicker?: TimepickerComponent;
    constructor(_renderer: Renderer2, _config: BsDatepickerConfig, _store: BsDatepickerStore, _element: ElementRef, _actions: BsDatepickerActions, _effects: BsDatepickerEffects, _positionService: PositioningService);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    get isTopPosition(): boolean;
    positionServiceEnable(): void;
    timeSelectHandler(date: Date, index: number): void;
    daySelectHandler(day: DayViewModel): void;
    monthSelectHandler(day: CalendarCellViewModel): void;
    yearSelectHandler(day: CalendarCellViewModel): void;
    rangesProcessing(day: CalendarCellViewModel): void;
    ngOnDestroy(): void;
    setRangeOnCalendar(dates: BsCustomDates): void;
    setMaxDateRangeOnCalendar(currentSelection: Date): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<BsDaterangepickerContainerComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<BsDaterangepickerContainerComponent, "bs-daterangepicker-container", never, {}, {}, never, never, false>;
}
