import { window } from './facade/browser';
export var BsVerions;
(function (BsVerions) {
    BsVerions["isBs3"] = "bs3";
    BsVerions["isBs4"] = "bs4";
    BsVerions["isBs5"] = "bs5";
})(BsVerions || (BsVerions = {}));
let guessedVersion;
function _guessBsVersion() {
    if (typeof window.document === 'undefined') {
        return 'bs4';
    }
    const spanEl = window.document.createElement('span');
    spanEl.innerText = 'testing bs version';
    spanEl.classList.add('d-none');
    spanEl.classList.add('pl-1');
    window.document.head.appendChild(spanEl);
    const rect = spanEl.getBoundingClientRect();
    const checkPadding = window.getComputedStyle(spanEl).paddingLeft;
    if (!rect || (rect && rect.top !== 0)) {
        window.document.head.removeChild(spanEl);
        return 'bs3';
    }
    if (checkPadding && parseFloat(checkPadding)) {
        window.document.head.removeChild(spanEl);
        return 'bs4';
    }
    window.document.head.removeChild(spanEl);
    return 'bs5';
}
export function setTheme(theme) {
    guessedVersion = theme;
}
// todo: in ngx-bootstrap, bs4 will became a default one
export function isBs3() {
    if (typeof window === 'undefined') {
        return true;
    }
    if (typeof window.__theme === 'undefined') {
        if (guessedVersion) {
            return guessedVersion === 'bs3';
        }
        guessedVersion = _guessBsVersion();
        return guessedVersion === 'bs3';
    }
    return window.__theme === 'bs3';
}
export function isBs4() {
    if (isBs3())
        return false;
    if (guessedVersion)
        return guessedVersion === 'bs4';
    guessedVersion = _guessBsVersion();
    return guessedVersion === 'bs4';
}
export function isBs5() {
    if (isBs3() || isBs4())
        return false;
    if (guessedVersion)
        return guessedVersion === 'bs5';
    guessedVersion = _guessBsVersion();
    return guessedVersion === 'bs5';
}
export function getBsVer() {
    return {
        isBs3: isBs3(),
        isBs4: isBs4(),
        isBs5: isBs5()
    };
}
export function currentBsVersion() {
    const bsVer = getBsVer();
    const resVersion = Object.keys(bsVer).find(key => bsVer[key]);
    return BsVerions[resVersion];
}
//# sourceMappingURL=data:application/json;base64,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