import { Component, HostBinding, Input } from '@angular/core';
import { AccordionService } from '../accordion.service';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
import * as i1 from "../accordion.service";
export class AccordionComponent {
    constructor(accordionService) {
        this.accordionService = accordionService;
    }
    /**
     * Make accordion items stay open when another item is opened
     * @type boolean
     */
    set alwaysOpen(value) {
        this.accordionService.alwaysOpen = coerceBooleanProperty(value);
    }
    get alwaysOpen() {
        return this.accordionService.alwaysOpen;
    }
    get hostClasses() {
        return {
            accordion: true,
            'accordion-flush': !!this.flush
        };
    }
}
AccordionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionComponent, deps: [{ token: i1.AccordionService }], target: i0.ɵɵFactoryTarget.Component });
AccordionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: AccordionComponent, selector: "c-accordion", inputs: { flush: "flush", alwaysOpen: "alwaysOpen" }, host: { properties: { "class": "this.hostClasses" } }, providers: [AccordionService], exportAs: ["cAccordionItem"], ngImport: i0, template: `<ng-content></ng-content>`, isInline: true, styles: [":host{display:block}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: AccordionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-accordion', template: `<ng-content></ng-content>`, exportAs: 'cAccordionItem', providers: [AccordionService], styles: [":host{display:block}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AccordionService }]; }, propDecorators: { flush: [{
                type: Input
            }], alwaysOpen: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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