import { Component, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class FormFeedbackComponent {
    constructor() {
        /**
         * If your form layout allows it, you can display validation feedback in a styled tooltip.
         */
        this._tooltip = false;
    }
    set tooltip(value) {
        this._tooltip = coerceBooleanProperty(value);
    }
    get tooltip() {
        return this._tooltip;
    }
    get hostClasses() {
        return {
            'valid-feedback': this.valid === true && !this.tooltip,
            'valid-tooltip': this.valid === true && this.tooltip,
            'invalid-feedback': this.valid !== true && !this.tooltip,
            'invalid-tooltip': this.valid !== true && this.tooltip
        };
    }
}
FormFeedbackComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: FormFeedbackComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
FormFeedbackComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: FormFeedbackComponent, selector: "c-form-feedback", inputs: { tooltip: "tooltip", valid: "valid" }, host: { properties: { "class": "this.hostClasses" } }, ngImport: i0, template: '<ng-content></ng-content>', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: FormFeedbackComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'c-form-feedback',
                    template: '<ng-content></ng-content>'
                }]
        }], propDecorators: { tooltip: [{
                type: Input
            }], valid: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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