import { Component, ElementRef, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/platform-browser";
import * as i2 from "../icon-set";
import * as i3 from "@angular/common";
import * as i4 from "../shared/html-attr.directive";
export class IconComponent {
    constructor(renderer, elementRef, sanitizer, iconSet) {
        this.renderer = renderer;
        this.elementRef = elementRef;
        this.sanitizer = sanitizer;
        this.iconSet = iconSet;
        this.attributes = { role: 'img' };
        this.size = '';
        this.use = '';
        this.customClasses = '';
        this.renderer.setStyle(this.elementRef.nativeElement, 'display', 'none');
    }
    set name(name) {
        this._name = name.includes('-') ? this.toCamelCase(name) : name;
    }
    get name() {
        return this._name;
    }
    set viewBox(viewBox) {
        this._viewBox = viewBox;
    }
    get viewBox() {
        return this._viewBox ?? this.scale;
    }
    get innerHtml() {
        const code = Array.isArray(this.code) ? this.code[1] || this.code[0] : this.code ?? '';
        // todo proper sanitize
        // const sanitized = this.sanitizer.sanitize(SecurityContext.HTML, code);
        return this.sanitizer.bypassSecurityTrustHtml((this.titleCode + code) ?? '');
    }
    ngAfterViewInit() {
        this.elementRef.nativeElement.classList.forEach((item) => {
            this.renderer.addClass(this.svgElementRef.nativeElement, item);
        });
        const parentElement = this.renderer.parentNode(this.elementRef.nativeElement);
        const svgElement = this.svgElementRef.nativeElement;
        this.renderer.insertBefore(parentElement, svgElement, this.elementRef.nativeElement);
        this.renderer.removeChild(parentElement, this.elementRef.nativeElement);
    }
    get titleCode() {
        return this.title ? `<title>${this.title}</title>` : '';
    }
    get code() {
        if (this.content) {
            return this.content;
        }
        if (this.iconSet && this.name) {
            return this.iconSet.getIcon(this.name);
        }
        if (this.name && !this.iconSet?.icons[this.name])
            console.warn(`c-icon component: icon name '${this.name}' does not exist for IconSet service. ` +
                `To use icon by 'name' prop you need to add it to IconSet service. \n`, this.name);
        return undefined;
    }
    get scale() {
        return Array.isArray(this.code) && this.code.length > 1 ? `0 0 ${this.code[0]}` : '0 0 64 64';
    }
    get computedSize() {
        const addCustom = !this.size && (this.width || this.height);
        return this.size === 'custom' || addCustom ? 'custom-size' : this.size;
    }
    get computedClasses() {
        const classes = {
            icon: true,
            [`icon-${this.computedSize}`]: !!this.computedSize
        };
        return !!this.customClasses ? this.customClasses : classes;
    }
    toCamelCase(str) {
        return str.replace(/([-_][a-z0-9])/ig, ($1) => {
            return $1.toUpperCase().replace('-', '');
        });
    }
}
IconComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: IconComponent, deps: [{ token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i1.DomSanitizer }, { token: i2.IconSetService }], target: i0.ɵɵFactoryTarget.Component });
IconComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: IconComponent, selector: "c-icon", inputs: { attributes: "attributes", content: "content", size: "size", title: "title", use: "use", customClasses: "customClasses", width: "width", height: "height", name: "name", viewBox: "viewBox" }, viewQueries: [{ propertyName: "svgElementRef", first: true, predicate: ["svgElement"], descendants: true, read: ElementRef }], ngImport: i0, template: "<svg *ngIf=\"(!use) && (!!code)\"\r\n     xmlns=\"http://www.w3.org/2000/svg\"\r\n     [attr.width]=\"width\"\r\n     [attr.height]=\"height || width\"\r\n     [attr.viewBox]=\"viewBox\"\r\n     [innerHtml]=\"innerHtml\"\r\n     [ngClass]=\"computedClasses\"\r\n     [cHtmlAttr]=\"attributes\"\r\n     role=\"img\"\r\n     pointer-events=\"none\"\r\n     #svgElement\r\n>\r\n</svg>\r\n\r\n<svg *ngIf=\"use\"\r\n     xmlns=\"http://www.w3.org/2000/svg\"\r\n     [attr.width]=\"width\"\r\n     [attr.height]=\"height || width\"\r\n     [ngClass]=\"computedClasses\"\r\n     [cHtmlAttr]=\"attributes\"\r\n     role=\"img\"\r\n     pointer-events=\"none\"\r\n>\r\n  <use [attr.href]=\"use\"></use>\r\n</svg>\r\n", styles: [".icon{display:inline-block;color:inherit;text-align:center;vertical-align:-.125rem;fill:currentColor}.icon:not(.icon-c-s):not(.icon-custom-size){width:1rem;height:1rem;font-size:1rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-xxl{width:2rem;height:2rem;font-size:2rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-xl{width:1.5rem;height:1.5rem;font-size:1.5rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-lg{width:1.25rem;height:1.25rem;font-size:1.25rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-sm{width:.875rem;height:.875rem;font-size:.875rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-3xl{width:3rem;height:3rem;font-size:3rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-4xl{width:4rem;height:4rem;font-size:4rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-5xl{width:5rem;height:5rem;font-size:5rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-6xl{width:6rem;height:6rem;font-size:6rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-7xl{width:7rem;height:7rem;font-size:7rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-8xl{width:8rem;height:8rem;font-size:8rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-9xl{width:9rem;height:9rem;font-size:9rem}\n"], dependencies: [{ kind: "directive", type: i3.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i4.HtmlAttributesDirective, selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: IconComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-icon', template: "<svg *ngIf=\"(!use) && (!!code)\"\r\n     xmlns=\"http://www.w3.org/2000/svg\"\r\n     [attr.width]=\"width\"\r\n     [attr.height]=\"height || width\"\r\n     [attr.viewBox]=\"viewBox\"\r\n     [innerHtml]=\"innerHtml\"\r\n     [ngClass]=\"computedClasses\"\r\n     [cHtmlAttr]=\"attributes\"\r\n     role=\"img\"\r\n     pointer-events=\"none\"\r\n     #svgElement\r\n>\r\n</svg>\r\n\r\n<svg *ngIf=\"use\"\r\n     xmlns=\"http://www.w3.org/2000/svg\"\r\n     [attr.width]=\"width\"\r\n     [attr.height]=\"height || width\"\r\n     [ngClass]=\"computedClasses\"\r\n     [cHtmlAttr]=\"attributes\"\r\n     role=\"img\"\r\n     pointer-events=\"none\"\r\n>\r\n  <use [attr.href]=\"use\"></use>\r\n</svg>\r\n", styles: [".icon{display:inline-block;color:inherit;text-align:center;vertical-align:-.125rem;fill:currentColor}.icon:not(.icon-c-s):not(.icon-custom-size){width:1rem;height:1rem;font-size:1rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-xxl{width:2rem;height:2rem;font-size:2rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-xl{width:1.5rem;height:1.5rem;font-size:1.5rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-lg{width:1.25rem;height:1.25rem;font-size:1.25rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-sm{width:.875rem;height:.875rem;font-size:.875rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-3xl{width:3rem;height:3rem;font-size:3rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-4xl{width:4rem;height:4rem;font-size:4rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-5xl{width:5rem;height:5rem;font-size:5rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-6xl{width:6rem;height:6rem;font-size:6rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-7xl{width:7rem;height:7rem;font-size:7rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-8xl{width:8rem;height:8rem;font-size:8rem}.icon:not(.icon-c-s):not(.icon-custom-size).icon-9xl{width:9rem;height:9rem;font-size:9rem}\n"] }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i1.DomSanitizer }, { type: i2.IconSetService }]; }, propDecorators: { attributes: [{
                type: Input
            }], content: [{
                type: Input
            }], size: [{
                type: Input
            }], title: [{
                type: Input
            }], use: [{
                type: Input
            }], customClasses: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }], name: [{
                type: Input
            }], viewBox: [{
                type: Input
            }], svgElementRef: [{
                type: ViewChild,
                args: ['svgElement', { read: ElementRef }]
            }] } });
//# sourceMappingURL=data:application/json;base64,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