import { BsCustomDates } from '../themes/bs/bs-custom-dates-view.component';
import { BsDatepickerEffects } from '../reducer/bs-datepicker.effects';
import { Observable, Subscription } from 'rxjs';
import { BsDatepickerViewMode, BsNavigationEvent, CalendarCellViewModel, CellHoverEvent, DatepickerRenderOptions, DatepickerDateCustomClasses, DatepickerDateTooltipText, DaysCalendarViewModel, DayViewModel, MonthsCalendarViewModel, WeekViewModel, YearsCalendarViewModel } from '../models';
export declare abstract class BsDatepickerAbstractComponent {
    containerClass: string;
    isOtherMonthsActive?: boolean;
    showTodayBtn?: boolean;
    todayBtnLbl?: string;
    todayPos?: string;
    showClearBtn?: boolean;
    clearBtnLbl?: string;
    clearPos?: string;
    _effects?: BsDatepickerEffects;
    customRanges: BsCustomDates[];
    customRangeBtnLbl?: string;
    chosenRange: Date[];
    multipleCalendars?: boolean;
    isRangePicker?: boolean;
    withTimepicker?: boolean;
    set minDate(value: Date | undefined);
    set maxDate(value: Date | undefined);
    set daysDisabled(value: number[] | undefined);
    set datesDisabled(value: Date[] | undefined);
    set datesEnabled(value: Date[] | undefined);
    set isDisabled(value: boolean | undefined);
    set dateCustomClasses(value: DatepickerDateCustomClasses[] | undefined);
    set dateTooltipTexts(value: DatepickerDateTooltipText[] | undefined);
    viewMode?: Observable<BsDatepickerViewMode | undefined>;
    monthsCalendar?: Observable<MonthsCalendarViewModel[] | undefined>;
    yearsCalendar?: Observable<YearsCalendarViewModel[] | undefined>;
    options$: Observable<DatepickerRenderOptions | undefined>;
    _daysCalendar$: Observable<DaysCalendarViewModel[] | undefined>;
    _daysCalendarSub: Subscription;
    set daysCalendar$(value: Observable<DaysCalendarViewModel[] | undefined>);
    get daysCalendar$(): Observable<DaysCalendarViewModel[] | undefined>;
    selectedTime?: Observable<Date[] | undefined>;
    selectedTimeSub: Subscription;
    setViewMode(event: BsDatepickerViewMode): void;
    navigateTo(event: BsNavigationEvent): void;
    dayHoverHandler(event: CellHoverEvent): void;
    weekHoverHandler(event: WeekViewModel): void;
    monthHoverHandler(event: CellHoverEvent): void;
    yearHoverHandler(event: CellHoverEvent): void;
    timeSelectHandler(date: Date, index: number): void;
    daySelectHandler(day: DayViewModel): void;
    monthSelectHandler(event: CalendarCellViewModel): void;
    yearSelectHandler(event: CalendarCellViewModel): void;
    setRangeOnCalendar(dates: BsCustomDates): void;
    setToday(): void;
    clearDate(): void;
    _stopPropagation(event: any): void;
}
