import { Component, Input, isDevMode, ChangeDetectionStrategy, Optional, Inject, } from '@angular/core';
import { start, end } from 'perf-marks/marks';
import { NGX_SKELETON_LOADER_CONFIG, } from './ngx-skeleton-loader-config.types';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
export class NgxSkeletonLoaderComponent {
    constructor(config) {
        const { appearance = 'line', animation = 'progress', theme = null, loadingText = 'Loading...', count = 1, ariaLabel = 'loading', } = config || {};
        this.appearance = appearance;
        this.animation = animation;
        this.theme = theme;
        this.loadingText = loadingText;
        this.count = count;
        this.items = [];
        this.ariaLabel = ariaLabel;
    }
    ngOnInit() {
        start('NgxSkeletonLoader:Rendered');
        start('NgxSkeletonLoader:Loaded');
        this.validateInputValues();
    }
    validateInputValues() {
        // Checking if it's receiving a numeric value (string having ONLY numbers or if it's a number)
        if (!/^\d+$/.test(`${this.count}`)) {
            // Shows error message only in Development
            if (isDevMode()) {
                console.error(`\`NgxSkeletonLoaderComponent\` need to receive 'count' a numeric value. Forcing default to "1".`);
            }
            this.count = 1;
        }
        this.items.length = this.count;
        const allowedAnimations = ['progress', 'progress-dark', 'pulse', 'false'];
        if (allowedAnimations.indexOf(String(this.animation)) === -1) {
            // Shows error message only in Development
            if (isDevMode()) {
                console.error(`\`NgxSkeletonLoaderComponent\` need to receive 'animation' as: ${allowedAnimations.join(', ')}. Forcing default to "progress".`);
            }
            this.animation = 'progress';
        }
        if (['circle', 'line', ''].indexOf(String(this.appearance)) === -1) {
            // Shows error message only in Development
            if (isDevMode()) {
                console.error(`\`NgxSkeletonLoaderComponent\` need to receive 'appearance' as: circle or line or empty string. Forcing default to "''".`);
            }
            this.appearance = '';
        }
    }
    ngOnChanges(changes) {
        // Avoiding multiple calls for the same input in case there's no changes in the fields
        // Checking if the fields that require validation are available and if they were changed
        // In case were not changed, we stop the function. Otherwise, `validateInputValues` will be called.
        if (['count', 'animation', 'appearance'].find(key => changes[key] && (changes[key].isFirstChange() || changes[key].previousValue === changes[key].currentValue))) {
            return;
        }
        this.validateInputValues();
    }
    ngAfterViewInit() {
        end('NgxSkeletonLoader:Rendered');
    }
    ngOnDestroy() {
        end('NgxSkeletonLoader:Loaded');
    }
}
/** @nocollapse */ /** @nocollapse */ NgxSkeletonLoaderComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.1.1", ngImport: i0, type: NgxSkeletonLoaderComponent, deps: [{ token: NGX_SKELETON_LOADER_CONFIG, optional: true }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ /** @nocollapse */ NgxSkeletonLoaderComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "13.1.1", type: NgxSkeletonLoaderComponent, selector: "ngx-skeleton-loader", inputs: { count: "count", loadingText: "loadingText", appearance: "appearance", animation: "animation", ariaLabel: "ariaLabel", theme: "theme" }, usesOnChanges: true, ngImport: i0, template: "<span\n  *ngFor=\"let item of items\"\n  class=\"loader\"\n  [attr.aria-label]=\"ariaLabel\"\n  aria-busy=\"true\"\n  aria-valuemin=\"0\"\n  aria-valuemax=\"100\"\n  [attr.aria-valuetext]=\"loadingText\"\n  role=\"progressbar\"\n  tabindex=\"0\"\n  [ngClass]=\"{\n    circle: appearance === 'circle',\n    progress: animation === 'progress',\n    'progress-dark': animation === 'progress-dark',\n    pulse: animation === 'pulse'\n  }\"\n  [ngStyle]=\"theme\"\n>\n</span>\n", styles: [".loader{box-sizing:border-box;overflow:hidden;position:relative;background:#eff1f6 no-repeat;border-radius:4px;width:100%;height:20px;display:inline-block;margin-bottom:10px;will-change:transform}.loader:after,.loader:before{box-sizing:border-box}.loader.circle{width:40px;height:40px;margin:5px;border-radius:50%}.loader.progress,.loader.progress-dark{transform:translate(0)}.loader.progress:after,.loader.progress:before,.loader.progress-dark:after,.loader.progress-dark:before{box-sizing:border-box}.loader.progress:before,.loader.progress-dark:before{-webkit-animation:progress 2s ease-in-out infinite;animation:progress 2s ease-in-out infinite;background-size:200px 100%;position:absolute;z-index:1;top:0;left:0;width:200px;height:100%;content:\"\"}.loader.progress:before{background-image:linear-gradient(90deg,rgba(255,255,255,0),rgba(255,255,255,.6),rgba(255,255,255,0))}.loader.progress-dark:before{background-image:linear-gradient(90deg,transparent,rgba(0,0,0,.2),transparent)}.loader.pulse{-webkit-animation:pulse 1.5s cubic-bezier(.4,0,.2,1) infinite;animation:pulse 1.5s cubic-bezier(.4,0,.2,1) infinite;-webkit-animation-delay:.5s;animation-delay:.5s}@media (prefers-reduced-motion: reduce){.loader.pulse,.loader.progress-dark,.loader.progress{-webkit-animation:none;animation:none}.loader.progress,.loader.progress-dark{background-image:none}}@-webkit-keyframes progress{0%{transform:translate(-200px)}to{transform:translate(calc(200px + 100vw))}}@keyframes progress{0%{transform:translate(-200px)}to{transform:translate(calc(200px + 100vw))}}@-webkit-keyframes pulse{0%{opacity:1}50%{opacity:.4}to{opacity:1}}@keyframes pulse{0%{opacity:1}50%{opacity:.4}to{opacity:1}}\n"], directives: [{ type: i1.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i1.NgStyle, selector: "[ngStyle]", inputs: ["ngStyle"] }], changeDetection: i0.ChangeDetectionStrategy.OnPush });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.1.1", ngImport: i0, type: NgxSkeletonLoaderComponent, decorators: [{
            type: Component,
            args: [{ selector: 'ngx-skeleton-loader', changeDetection: ChangeDetectionStrategy.OnPush, template: "<span\n  *ngFor=\"let item of items\"\n  class=\"loader\"\n  [attr.aria-label]=\"ariaLabel\"\n  aria-busy=\"true\"\n  aria-valuemin=\"0\"\n  aria-valuemax=\"100\"\n  [attr.aria-valuetext]=\"loadingText\"\n  role=\"progressbar\"\n  tabindex=\"0\"\n  [ngClass]=\"{\n    circle: appearance === 'circle',\n    progress: animation === 'progress',\n    'progress-dark': animation === 'progress-dark',\n    pulse: animation === 'pulse'\n  }\"\n  [ngStyle]=\"theme\"\n>\n</span>\n", styles: [".loader{box-sizing:border-box;overflow:hidden;position:relative;background:#eff1f6 no-repeat;border-radius:4px;width:100%;height:20px;display:inline-block;margin-bottom:10px;will-change:transform}.loader:after,.loader:before{box-sizing:border-box}.loader.circle{width:40px;height:40px;margin:5px;border-radius:50%}.loader.progress,.loader.progress-dark{transform:translate(0)}.loader.progress:after,.loader.progress:before,.loader.progress-dark:after,.loader.progress-dark:before{box-sizing:border-box}.loader.progress:before,.loader.progress-dark:before{-webkit-animation:progress 2s ease-in-out infinite;animation:progress 2s ease-in-out infinite;background-size:200px 100%;position:absolute;z-index:1;top:0;left:0;width:200px;height:100%;content:\"\"}.loader.progress:before{background-image:linear-gradient(90deg,rgba(255,255,255,0),rgba(255,255,255,.6),rgba(255,255,255,0))}.loader.progress-dark:before{background-image:linear-gradient(90deg,transparent,rgba(0,0,0,.2),transparent)}.loader.pulse{-webkit-animation:pulse 1.5s cubic-bezier(.4,0,.2,1) infinite;animation:pulse 1.5s cubic-bezier(.4,0,.2,1) infinite;-webkit-animation-delay:.5s;animation-delay:.5s}@media (prefers-reduced-motion: reduce){.loader.pulse,.loader.progress-dark,.loader.progress{-webkit-animation:none;animation:none}.loader.progress,.loader.progress-dark{background-image:none}}@-webkit-keyframes progress{0%{transform:translate(-200px)}to{transform:translate(calc(200px + 100vw))}}@keyframes progress{0%{transform:translate(-200px)}to{transform:translate(calc(200px + 100vw))}}@-webkit-keyframes pulse{0%{opacity:1}50%{opacity:.4}to{opacity:1}}@keyframes pulse{0%{opacity:1}50%{opacity:.4}to{opacity:1}}\n"] }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [NGX_SKELETON_LOADER_CONFIG]
                }, {
                    type: Optional
                }] }]; }, propDecorators: { count: [{
                type: Input
            }], loadingText: [{
                type: Input
            }], appearance: [{
                type: Input
            }], animation: [{
                type: Input
            }], ariaLabel: [{
                type: Input
            }], theme: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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